*The Effects of Fiscal Measures During Covid-19* 
*Pragyan Deb, Davide Furceri, Jonathan D. Ostry, Nour Tawk, Naihan Yang* 

*Figure 8 Results* 
*3. WEEKLY SHOCKS, OECD TRACKER* 

global MYDATA "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb"
global SAVING "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb\results" 

cd $ME
clear all
set maxvar 120000

* Load data
use "$MYDATA\weekly_dta_toJMCB.dta", clear
cd "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb\results"


foreach shock in fp_res_frn {


foreach dep in OECDTrackeryoy {

/*---------------------------------------------------------*/
/* Define parameters for LP                  			   */
/*---------------------------------------------------------*/

* Number of lags in LP
local MaxLPLags 1

* LP horizon
local horizon 15

/*---------------------------------------------------------*/
/* Baseline LP regressions                  			   */
/*---------------------------------------------------------*/

* variables to store the impulse response (vector of betas from the LP regressions) and standard errors
gen cb_`dep'=0
gen cse_`dep'=0

* One regression for each horizon of the response
capture erase LP_`dep'_`shock'.xml
capture erase LP_`dep'_`shock'.txt
capture erase cLP_`dep'_`shock'.xml
capture erase cLP_`dep'_`shock'.txt

forvalues i=1/`horizon' {


*baseline*
local control l(1/`MaxLPLags').(d.`dep') l(1/`MaxLPLags').(`shock') l(1/`MaxLPLags').(d.c) l(1/`MaxLPLags').(d.d) l(1/`MaxLPLags').(d.mes) l(1/`MaxLPLags').(close) l(1/`MaxLPLags').(mp_gdp)  c.week#code
	
	gen y=f`i'.`dep'-l.`dep'
	
	xtreg y `shock' `control', fe cluster(code)
	outreg2 using cLP_`dep'_`shock', append title("Dependent Variable: `: var label `dep'' cumulative difference") ctitle("f`i'.`dep'") excel  
	
	scalar ssize=e(N_clust)

	replace cb_`dep'  = _b[`shock']*100 if _n == `i'+1
	replace cse_`dep' = _se[`shock']*100 if _n == `i'+1
	
	drop y

}

* Create impulse response graphs

* create x and y axis line
gen zero = 0 if _n <= `horizon' +1
gen tg = _n-1 if _n <= `horizon' +1


* Create confidence bands (in this case 90 and 70%)
scalar sig1 = 0.05	 // specify significance level
scalar sig2 = 0.25	 // specify significance level

* cumulative log difference
gen cup_`dep' = cb_`dep' + invnormal(1-sig1/2)*cse_`dep' if _n <= (`horizon' + 1)
gen cdn_`dep' = cb_`dep' - invnormal(1-sig1/2)*cse_`dep' if _n <= (`horizon' + 1)

gen cup2_`dep' = cb_`dep' + invnormal(1-sig2/2)*cse_`dep' if _n <= (`horizon' + 1)
gen cdn2_`dep' = cb_`dep' - invnormal(1-sig2/2)*cse_`dep' if _n <= (`horizon' + 1)
	
	grstyle init
	grstyle set nogrid
	twoway (rarea cup_`dep' cdn_`dep'  tg, ///
	fcolor(gs12) lcolor(white) lpattern(solid)) ///
	(rarea cup2_`dep' cdn2_`dep'  tg, ///
	 fcolor(gs10) lcolor(white) lpattern(solid)) ///
	(line cb_`dep' tg, lcolor(blue) ///
	xlabel(,labsize(large)) ///
	ylabel(,labsize(large)) ///
	lpattern(solid) lwidth(thick)) /// 
	(line zero tg, lcolor(black)), ///
	title("`: var label `dep'', deviation from baseline, percent", color(black) size(small)) ///
	xtitle("Days after announcement of fiscal packages", size(small))  ///
	graphregion(color(white)) plotregion(color(white)) ///
	legend(off) name(c`dep', replace) nodraw
	graph save   cLP_`dep'_`shock'.gph, replace

}

}

export excel cb_OECDTrackeryoy cup_OECDTrackeryoy cdn_OECDTrackeryoy	cup2_OECDTrackeryoy cdn2_OECDTrackeryoy using  "$SAVING\OECD_BETA CI.xls", sheet("`LHS'") sheetmodify firstrow(variables)		

